<?php
/**
 * Script to generate functions _menu_installed_items() and _menus_altered()
 */

include_once DRUPAL_ROOT . '/includes/utility.inc';
$menus = array( 'menu-ace-notification-menu', 'main-menu');
$mainMenuArray = array();
//mlid to alias map
$alias_map = array();
$menu_items = array();

$output = "function _menus_altered(){ \n";
$output .= "     return array (\n";

foreach($menus as $menu){
$mainMenuArray = $mainMenuArray + menu_load_links($menu);

$mlid_ins = db_select('menu_links', 'ml')
->fields('ml', array('mlid', 'link_path'))
->condition('ml.menu_name', $menu)
->execute()->fetchAllAssoc('mlid', PDO::FETCH_ASSOC);

$menu_items = $menu_items + $mlid_ins;
$output .=  "'" . $menu . "',\n";
}
$output .= "    );\n";
$output .= "}\n\n\n";

//generate the map between mlid and alias path
foreach($menu_items as $mlid => $options){
$alias_map[$mlid] = drupal_get_path_alias($options['link_path']);
}

$output .= "function _menu_installed_items() {\n";
$output .= "     return array (\n";
foreach($mainMenuArray as $key => $link){
$alias_path = drupal_get_path_alias($link['link_path']);

//prepare link to pass in menu_link_save()
$link_export = $link;
$link_export['link_path'] = $alias_path;
unset($link_export['mlid']);
unset($link_export['router_path']);
unset($link_export['options']['identifier']);
$link_export['plid'] = ($link_export['plid']) ? $alias_map[$link_export['plid']] : $link_export['plid'] ;
$link_export['p1'] = ($link_export['p1']) ? $alias_map[$link_export['p1']] : $link_export['p1'] ;
$link_export['p2'] = ($link_export['p2']) ? $alias_map[$link_export['p2']] : $link_export['p2'] ;
$link_export['p3'] = ($link_export['p3']) ? $alias_map[$link_export['p3']] : $link_export['p3'] ;

$output .= "'" . $alias_path ."' => " . drupal_var_export($link_export) . ",\n";
}
$output .= ");\n";
$output .="}\n";

drupal_set_message("<textarea rows=100 style=\"width: 100%;\">" . $output . '</textarea>');
