<?php
/**
 * @file
 * diamond.features.field.inc
 */

/**
 * Implements hook_field_default_fields().
 */
function diamond_field_default_fields() {
  $fields = array();

  // Exported field: 'commerce_product-diamond-commerce_price'.
  $fields['commerce_product-diamond-commerce_price'] = array(
    'field_config' => array(
      'active' => '1',
      'cardinality' => '1',
      'deleted' => '0',
      'entity_types' => array(
        0 => 'commerce_product',
      ),
      'field_name' => 'commerce_price',
      'foreign keys' => array(),
      'indexes' => array(
        'currency_price' => array(
          0 => 'amount',
          1 => 'currency_code',
        ),
      ),
      'locked' => '1',
      'module' => 'commerce_price',
      'settings' => array(
        'entity_translation_sync' => FALSE,
      ),
      'translatable' => '0',
      'type' => 'commerce_price',
    ),
    'field_instance' => array(
      'bundle' => 'diamond',
      'default_value' => NULL,
      'deleted' => '0',
      'description' => '',
      'display' => array(
        'add_to_cart_confirmation_view' => array(
          'label' => 'inline',
          'module' => 'commerce_extra_price_formatters',
          'settings' => array(
            'alternative_text_for_zero_price' => '',
            'calculation' => 'calculated_sell_price',
            'raw' => FALSE,
            'text_format' => NULL,
          ),
          'type' => 'commerce_price_no_decimals',
          'weight' => '1',
        ),
        'commerce_line_item_display' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'commerce_line_item_token' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'default' => array(
          'label' => 'hidden',
          'module' => 'commerce_extra_price_formatters',
          'settings' => array(
            'alternative_text_for_zero_price' => '',
            'calculation' => 1,
            'prefix' => 'Total Price:',
            'suffix' => '',
            'text_format' => 'commerce_order_message',
            'whole_numbers_only' => 1,
          ),
          'type' => 'commerce_price_prefix_suffix',
          'weight' => '0',
        ),
        'full' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'line_item' => array(
          'label' => 'hidden',
          'module' => 'commerce_extra_price_formatters',
          'settings' => array(
            'alternative_text_for_zero_price' => '',
            'calculation' => 'calculated_sell_price',
            'raw' => FALSE,
            'text_format' => NULL,
          ),
          'type' => 'commerce_price_no_decimals',
          'weight' => '0',
        ),
        'node_full' => array(
          'label' => 'inline',
          'module' => 'commerce_extra_price_formatters',
          'settings' => array(
            'alternative_text_for_zero_price' => '',
            'calculation' => TRUE,
            'raw' => 0,
            'text_format' => 'full_html',
          ),
          'type' => 'commerce_price_no_decimals',
          'weight' => '0',
        ),
        'node_product_list' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'node_rss' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'node_scs' => array(
          'label' => 'inline',
          'module' => 'commerce_extra_price_formatters',
          'settings' => array(
            'alternative_text_for_zero_price' => '',
            'calculation' => 1,
            'raw' => FALSE,
            'text_format' => 'commerce_order_message',
          ),
          'type' => 'commerce_price_no_decimals',
          'weight' => '3',
        ),
        'node_teaser' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'node_token' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
        'product_in_cart' => array(
          'label' => 'hidden',
          'module' => 'commerce_extra_price_formatters',
          'settings' => array(
            'alternative_text_for_zero_price' => '',
            'calculation' => TRUE,
            'raw' => 0,
            'text_format' => 'commerce_order_message',
          ),
          'type' => 'commerce_price_no_decimals',
          'weight' => '0',
        ),
        'token' => array(
          'label' => 'hidden',
          'module' => 'commerce_price',
          'settings' => array(
            'calculation' => 'calculated_sell_price',
          ),
          'type' => 'commerce_price_formatted_amount',
          'weight' => 0,
        ),
      ),
      'entity_type' => 'commerce_product',
      'field_name' => 'commerce_price',
      'label' => 'Price',
      'required' => TRUE,
      'settings' => array(
        'entity_translation_sync' => FALSE,
        'user_register_form' => FALSE,
      ),
      'widget' => array(
        'module' => 'commerce_price',
        'settings' => array(
          'currency_code' => 'default',
        ),
        'type' => 'commerce_price_full',
        'weight' => '2',
      ),
    ),
  );

  // Exported field: 'commerce_product-diamond-field_diamond_image'.
  $fields['commerce_product-diamond-field_diamond_image'] = array(
    'field_config' => array(
      'active' => '1',
      'cardinality' => '4',
      'deleted' => '0',
      'entity_types' => array(),
      'field_name' => 'field_diamond_image',
      'foreign keys' => array(
        'fid' => array(
          'columns' => array(
            'fid' => 'fid',
          ),
          'table' => 'file_managed',
        ),
      ),
      'indexes' => array(
        'fid' => array(
          0 => 'fid',
        ),
      ),
      'locked' => '0',
      'module' => 'image',
      'settings' => array(
        'default_image' => 0,
        'entity_translation_sync' => array(
          0 => 'fid',
        ),
        'uri_scheme' => 'public',
      ),
      'translatable' => '0',
      'type' => 'image',
    ),
    'field_instance' => array(
      'bundle' => 'diamond',
      'deleted' => '0',
      'description' => '',
      'display' => array(
        'add_to_cart_confirmation_view' => array(
          'label' => 'above',
          'settings' => array(),
          'type' => 'hidden',
          'weight' => '3',
        ),
        'default' => array(
          'label' => 'hidden',
          'module' => 'cloud_zoom',
          'settings' => array(
            'gallery_filedset' => array(
              'gallery_mode' => FALSE,
              'thumb_style' => 0,
            ),
            'slide_style' => 0,
            'zoom_position_fieldset' => array(
              'adjust_x' => 0,
              'adjust_y' => 0,
              'position' => 'right',
              'zoom_height' => 'auto',
              'zoom_width' => 'auto',
            ),
            'zoom_style' => 0,
            'zoom_style_fieldset' => array(
              'Show title' => TRUE,
              'lens_opacity' => 0.5,
              'smooth_move' => 3,
              'soft_focus' => FALSE,
              'tint' => 'false',
              'tint_opacity' => 0.5,
              'title_opacity' => 0.5,
            ),
          ),
          'type' => 'cloud_zoom',
          'weight' => '1',
        ),
        'line_item' => array(
          'label' => 'above',
          'settings' => array(),
          'type' => 'hidden',
          'weight' => '0',
        ),
        'node_full' => array(
          'label' => 'hidden',
          'module' => 'cloud_zoom',
          'settings' => array(
            'gallery_filedset' => array(
              'gallery_mode' => 1,
              'thumb_style' => 'diamond_view_50x50',
            ),
            'slide_style' => 'jewelry_page_image',
            'zoom_position_fieldset' => array(
              'adjust_x' => '0',
              'adjust_y' => '0',
              'position' => 'inside',
              'zoom_height' => 'auto',
              'zoom_width' => 'auto',
            ),
            'zoom_style' => '0',
            'zoom_style_fieldset' => array(
              'Show title' => 1,
              'lens_opacity' => '0.5',
              'smooth_move' => '3',
              'soft_focus' => 0,
              'tint' => 'false',
              'tint_opacity' => '0.5',
              'title_opacity' => '0.5',
            ),
          ),
          'type' => 'cloud_zoom',
          'weight' => '1',
        ),
        'node_scs' => array(
          'label' => 'hidden',
          'module' => 'image',
          'settings' => array(
            'image_link' => 'content',
            'image_style' => 'cart_image',
          ),
          'type' => 'image',
          'weight' => '0',
        ),
        'product_in_cart' => array(
          'label' => 'above',
          'settings' => array(),
          'type' => 'hidden',
          'weight' => '0',
        ),
      ),
      'entity_type' => 'commerce_product',
      'fences_wrapper' => '',
      'field_name' => 'field_diamond_image',
      'label' => 'Image',
      'required' => 0,
      'settings' => array(
        'alt_field' => 1,
        'default_image' => 0,
        'entity_translation_sync' => FALSE,
        'file_directory' => 'product_files/product_images',
        'file_extensions' => 'png gif jpg jpeg',
        'max_filesize' => '',
        'max_resolution' => '',
        'min_resolution' => '',
        'title_field' => 1,
        'user_register_form' => FALSE,
      ),
      'widget' => array(
        'active' => 1,
        'module' => 'image',
        'settings' => array(
          'preview_image_style' => 'thumbnail',
          'progress_indicator' => 'throbber',
        ),
        'type' => 'image_image',
        'weight' => '4',
      ),
    ),
  );

  // Exported field: 'commerce_product-diamond-title_field'.
  $fields['commerce_product-diamond-title_field'] = array(
    'field_config' => array(
      'active' => '1',
      'cardinality' => '1',
      'deleted' => '0',
      'entity_types' => array(),
      'field_name' => 'title_field',
      'foreign keys' => array(
        'format' => array(
          'columns' => array(
            'format' => 'format',
          ),
          'table' => 'filter_format',
        ),
      ),
      'indexes' => array(
        'format' => array(
          0 => 'format',
        ),
      ),
      'locked' => '0',
      'module' => 'text',
      'settings' => array(
        'entity_translation_sync' => FALSE,
        'max_length' => 255,
      ),
      'translatable' => '1',
      'type' => 'text',
    ),
    'field_instance' => array(
      'bundle' => 'diamond',
      'default_value' => NULL,
      'deleted' => '0',
      'description' => '',
      'display' => array(
        'add_to_cart_confirmation_view' => array(
          'label' => 'inline',
          'module' => 'text',
          'settings' => array(),
          'type' => 'text_default',
          'weight' => '0',
        ),
        'default' => array(
          'label' => 'hidden',
          'module' => 'text',
          'settings' => array(),
          'type' => 'text_default',
          'weight' => '0',
        ),
        'line_item' => array(
          'label' => 'above',
          'settings' => array(),
          'type' => 'hidden',
          'weight' => '0',
        ),
        'node_full' => array(
          'label' => 'hidden',
          'module' => 'text',
          'settings' => array(),
          'type' => 'text_default',
          'weight' => '0',
        ),
        'node_scs' => array(
          'label' => 'inline',
          'module' => 'text',
          'settings' => array(),
          'type' => 'text_plain',
          'weight' => '2',
        ),
        'product_in_cart' => array(
          'label' => 'above',
          'settings' => array(),
          'type' => 'hidden',
          'weight' => '0',
        ),
      ),
      'entity_type' => 'commerce_product',
      'field_name' => 'title_field',
      'label' => 'Title',
      'required' => 1,
      'settings' => array(
        'entity_translation_sync' => FALSE,
        'hide_label' => array(
          'entity' => 'entity',
          'page' => 0,
        ),
        'text_processing' => '0',
        'user_register_form' => FALSE,
      ),
      'widget' => array(
        'active' => 1,
        'module' => 'text',
        'settings' => array(
          'size' => '60',
        ),
        'type' => 'text_textfield',
        'weight' => '1',
      ),
    ),
  );

  // Translatables
  // Included for use with string extractors like potx.
  t('Image');
  t('Price');
  t('Title');

  return $fields;
}
