/**
 * jQuery gMap - Google Maps API V3
 *
 * @license MIT License; http://www.opensource.org/licenses/mit-license.php
 * @url		http://github.com/marioestrada/jQuery-gMap
 * @author	Mario Estrada <me@mario.ec> based on original plugin by Cedric Kastner <cedric@nur-text.de>
 * @version	2.1.4
 */

(function($){$.fn.gMap=function(options,methods_options){switch(options){case"addMarker":return $(this).trigger("gMap.addMarker",[methods_options.latitude,methods_options.longitude,methods_options.content,methods_options.icon,methods_options.popup]);case"centerAt":return $(this).trigger("gMap.centerAt",[methods_options.latitude,methods_options.longitude,methods_options.zoom]);case"clearMarkers":return $(this).trigger("gMap.clearMarkers")}var opts=$.extend({},$.fn.gMap.defaults,options);return this.each(function(){var $gmap=new google.maps.Map(this);$(this).data("gMap.reference",$gmap);var $geocoder=new google.maps.Geocoder;if(opts.address){$geocoder.geocode({address:opts.address},function(gresult,status){if(gresult&&gresult.length)$gmap.setCenter(gresult[0].geometry.location)})}else{if(opts.latitude&&opts.longitude){$gmap.setCenter(new google.maps.LatLng(opts.latitude,opts.longitude))}else{if($.isArray(opts.markers)&&opts.markers.length>0){if(opts.markers[0].address){$geocoder.geocode({address:opts.markers[0].address},function(gresult,status){if(gresult&&gresult.length>0)$gmap.setCenter(gresult[0].geometry.location)})}else{$gmap.setCenter(new google.maps.LatLng(opts.markers[0].latitude,opts.markers[0].longitude))}}else{$gmap.setCenter(new google.maps.LatLng(34.885931,9.84375))}}}$gmap.setZoom(opts.zoom);$gmap.setMapTypeId(google.maps.MapTypeId[opts.maptype]);var map_options={scrollwheel:opts.scrollwheel,disableDoubleClickZoom:!opts.doubleclickzoom};if(opts.controls===false){$.extend(map_options,{disableDefaultUI:true})}else if(opts.controls.length!=0){$.extend(map_options,opts.controls,{disableDefaultUI:true})}$gmap.setOptions(map_options);var gicon=new google.maps.Marker;marker_icon=new google.maps.MarkerImage(opts.icon.image);marker_icon.size=new google.maps.Size(opts.icon.iconsize[0],opts.icon.iconsize[1]);marker_icon.anchor=new google.maps.Point(opts.icon.iconanchor[0],opts.icon.iconanchor[1]);gicon.setIcon(marker_icon);if(opts.icon.shadow){marker_shadow=new google.maps.MarkerImage(opts.icon.shadow);marker_shadow.size=new google.maps.Size(opts.icon.shadowsize[0],opts.icon.shadowsize[1]);marker_shadow.anchor=new google.maps.Point(opts.icon.shadowanchor[0],opts.icon.shadowanchor[1]);gicon.setShadow(marker_shadow)}$(this).bind("gMap.centerAt",function(e,latitude,longitude,zoom){if(zoom)$gmap.setZoom(zoom);$gmap.panTo(new google.maps.LatLng(parseFloat(latitude),parseFloat(longitude)))});var overlays=[];$(this).bind("gMap.clearMarkers",function(){while(overlays[0]){overlays.pop().setMap(null)}});var last_infowindow;$(this).bind("gMap.addMarker",function(e,latitude,longitude,content,icon,popup){var glatlng=new google.maps.LatLng(parseFloat(latitude),parseFloat(longitude));var gmarker=new google.maps.Marker({position:glatlng});if(icon){marker_icon=new google.maps.MarkerImage(icon.image);marker_icon.size=new google.maps.Size(icon.iconsize[0],icon.iconsize[1]);marker_icon.anchor=new google.maps.Point(icon.iconanchor[0],icon.iconanchor[1]);gmarker.setIcon(marker_icon);if(icon.shadow){marker_shadow=new google.maps.MarkerImage(icon.shadow);marker_shadow.size=new google.maps.Size(icon.shadowsize[0],icon.shadowsize[1]);marker_shadow.anchor=new google.maps.Point(icon.shadowanchor[0],icon.shadowanchor[1]);gicon.setShadow(marker_shadow)}}else{gmarker.setIcon(gicon.getIcon());gmarker.setShadow(gicon.getShadow())}if(content){if(content=="_latlng")content=latitude+", "+longitude;var infowindow=new google.maps.InfoWindow({content:opts.html_prepend+content+opts.html_append});google.maps.event.addListener(gmarker,"click",function(){last_infowindow&&last_infowindow.close();infowindow.open($gmap,gmarker);last_infowindow=infowindow});if(popup){google.maps.event.addListenerOnce($gmap,"tilesloaded",function(){infowindow.open($gmap,gmarker)})}}gmarker.setMap($gmap);overlays.push(gmarker)});for(var j=0;j<opts.markers.length;j++){marker=opts.markers[j];if(marker.address){if(marker.html=="_address")marker.html=marker.address;var $this=this;$geocoder.geocode({address:marker.address},function(marker,$this){return function(gresult,status){if(gresult&&gresult.length>0){$($this).trigger("gMap.addMarker",[gresult[0].geometry.location.lat(),gresult[0].geometry.location.lng(),marker.html,marker.icon,marker.popup])}}}(marker,$this))}else{$(this).trigger("gMap.addMarker",[marker.latitude,marker.longitude,marker.html,marker.icon,marker.popup])}}})};$.fn.gMap.defaults={address:"",latitude:0,longitude:0,zoom:1,markers:[],controls:[],scrollwheel:false,doubleclickzoom:true,maptype:"ROADMAP",html_prepend:'<div class="gmap_marker">',html_append:"</div>",icon:{image:"http://www.google.com/mapfiles/marker.png",shadow:"http://www.google.com/mapfiles/shadow50.png",iconsize:[20,34],shadowsize:[37,34],iconanchor:[9,34],shadowanchor:[6,34]}}})(jQuery);;
(function ($) {

  Drupal.behaviors.exampleModule = {
    attach: function (context, settings) {
      $('.google-map', context).each(function () {
        $this = $(this);

        var $address = $this.attr('data-address');
        var $html = $this.attr('data-html');

        contactblock_generate_map($this, $address, $html);

      });

    }
  };



  function contactblock_generate_map($item, address, html) {
    $item.gMap({
      maptype: 'ROADMAP',
      scrollwheel: false,
      zoom: 13,
      markers: [
        {
          address: address, // Your Adress Here
          html: html,
          popup: true
        }
      ]
    });
  }


})(jQuery);


;
(function ($) {

Drupal.behaviors.textarea = {
  attach: function (context, settings) {
    $('.form-textarea-wrapper.resizable', context).once('textarea', function () {
      var staticOffset = null;
      var textarea = $(this).addClass('resizable-textarea').find('textarea');
      var grippie = $('<div class="grippie"></div>').mousedown(startDrag);

      grippie.insertAfter(textarea);

      function startDrag(e) {
        staticOffset = textarea.height() - e.pageY;
        textarea.css('opacity', 0.25);
        $(document).mousemove(performDrag).mouseup(endDrag);
        return false;
      }

      function performDrag(e) {
        textarea.height(Math.max(32, staticOffset + e.pageY) + 'px');
        return false;
      }

      function endDrag(e) {
        $(document).unbind('mousemove', performDrag).unbind('mouseup', endDrag);
        textarea.css('opacity', 1);
      }
    });
  }
};

})(jQuery);
;
(function ($) {

Drupal.googleanalytics = {};

$(document).ready(function() {

  // Attach mousedown, keyup, touchstart events to document only and catch
  // clicks on all elements.
  $(document.body).bind("mousedown keyup touchstart", function(event) {

    // Catch the closest surrounding link of a clicked element.
    $(event.target).closest("a,area").each(function() {

      // Is the clicked URL internal?
      if (Drupal.googleanalytics.isInternal(this.href)) {
        // Skip 'click' tracking, if custom tracking events are bound.
        if ($(this).is('.colorbox') && (Drupal.settings.googleanalytics.trackColorbox)) {
          // Do nothing here. The custom event will handle all tracking.
          //console.info("Click on .colorbox item has been detected.");
        }
        // Is download tracking activated and the file extension configured for download tracking?
        else if (Drupal.settings.googleanalytics.trackDownload && Drupal.googleanalytics.isDownload(this.href)) {
          // Download link clicked.
          ga("send", {
            "hitType": "event",
            "eventCategory": "Downloads",
            "eventAction": Drupal.googleanalytics.getDownloadExtension(this.href).toUpperCase(),
            "eventLabel": Drupal.googleanalytics.getPageUrl(this.href),
            "transport": "beacon"
          });
        }
        else if (Drupal.googleanalytics.isInternalSpecial(this.href)) {
          // Keep the internal URL for Google Analytics website overlay intact.
          ga("send", {
            "hitType": "pageview",
            "page": Drupal.googleanalytics.getPageUrl(this.href),
            "transport": "beacon"
          });
        }
      }
      else {
        if (Drupal.settings.googleanalytics.trackMailto && $(this).is("a[href^='mailto:'],area[href^='mailto:']")) {
          // Mailto link clicked.
          ga("send", {
            "hitType": "event",
            "eventCategory": "Mails",
            "eventAction": "Click",
            "eventLabel": this.href.substring(7),
            "transport": "beacon"
          });
        }
        else if (Drupal.settings.googleanalytics.trackOutbound && this.href.match(/^\w+:\/\//i)) {
          if (Drupal.settings.googleanalytics.trackDomainMode !== 2 || (Drupal.settings.googleanalytics.trackDomainMode === 2 && !Drupal.googleanalytics.isCrossDomain(this.hostname, Drupal.settings.googleanalytics.trackCrossDomains))) {
            // External link clicked / No top-level cross domain clicked.
            ga("send", {
              "hitType": "event",
              "eventCategory": "Outbound links",
              "eventAction": "Click",
              "eventLabel": this.href,
              "transport": "beacon"
            });
          }
        }
      }
    });
  });

  // Track hash changes as unique pageviews, if this option has been enabled.
  if (Drupal.settings.googleanalytics.trackUrlFragments) {
    window.onhashchange = function() {
      ga("send", {
        "hitType": "pageview",
        "page": location.pathname + location.search + location.hash
      });
    };
  }

  // Colorbox: This event triggers when the transition has completed and the
  // newly loaded content has been revealed.
  if (Drupal.settings.googleanalytics.trackColorbox) {
    $(document).bind("cbox_complete", function () {
      var href = $.colorbox.element().attr("href");
      if (href) {
        ga("send", {
          "hitType": "pageview",
          "page": Drupal.googleanalytics.getPageUrl(href)
        });
      }
    });
  }

});

/**
 * Check whether the hostname is part of the cross domains or not.
 *
 * @param string hostname
 *   The hostname of the clicked URL.
 * @param array crossDomains
 *   All cross domain hostnames as JS array.
 *
 * @return boolean
 */
Drupal.googleanalytics.isCrossDomain = function (hostname, crossDomains) {
  /**
   * jQuery < 1.6.3 bug: $.inArray crushes IE6 and Chrome if second argument is
   * `null` or `undefined`, http://bugs.jquery.com/ticket/10076,
   * https://github.com/jquery/jquery/commit/a839af034db2bd934e4d4fa6758a3fed8de74174
   *
   * @todo: Remove/Refactor in D8
   */
  if (!crossDomains) {
    return false;
  }
  else {
    return $.inArray(hostname, crossDomains) > -1 ? true : false;
  }
};

/**
 * Check whether this is a download URL or not.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isDownload = function (url) {
  var isDownload = new RegExp("\\.(" + Drupal.settings.googleanalytics.trackDownloadExtensions + ")([\?#].*)?$", "i");
  return isDownload.test(url);
};

/**
 * Check whether this is an absolute internal URL or not.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isInternal = function (url) {
  var isInternal = new RegExp("^(https?):\/\/" + window.location.host, "i");
  return isInternal.test(url);
};

/**
 * Check whether this is a special URL or not.
 *
 * URL types:
 *  - gotwo.module /go/* links.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isInternalSpecial = function (url) {
  var isInternalSpecial = new RegExp("(\/go\/.*)$", "i");
  return isInternalSpecial.test(url);
};

/**
 * Extract the relative internal URL from an absolute internal URL.
 *
 * Examples:
 * - http://mydomain.com/node/1 -> /node/1
 * - http://example.com/foo/bar -> http://example.com/foo/bar
 *
 * @param string url
 *   The web url to check.
 *
 * @return string
 *   Internal website URL
 */
Drupal.googleanalytics.getPageUrl = function (url) {
  var extractInternalUrl = new RegExp("^(https?):\/\/" + window.location.host, "i");
  return url.replace(extractInternalUrl, '');
};

/**
 * Extract the download file extension from the URL.
 *
 * @param string url
 *   The web url to check.
 *
 * @return string
 *   The file extension of the passed url. e.g. "zip", "txt"
 */
Drupal.googleanalytics.getDownloadExtension = function (url) {
  var extractDownloadextension = new RegExp("\\.(" + Drupal.settings.googleanalytics.trackDownloadExtensions + ")([\?#].*)?$", "i");
  var extension = extractDownloadextension.exec(url);
  return (extension === null) ? '' : extension[1];
};

})(jQuery);
;
